	subroutine SHAPEB(iout, idbg, Ne, Nn, Nb, Ng, Sx, BCe, Bci, ie, x, xg, &
			  Jib, a33, Shpb, dNdrb)
! calculate element shape functions on boundary faces
! note that on element boundaries W=N

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb, Ng			! array parameters
	real*8 Sx
	integer BCe(Nb,3), BCi(Nb)		! BC element and local element face numbers
	integer ie(Ne,5)			! global connectivity array
	real*8 x(Nn,2)				! global coordinates array
	real*8 xg(Ng)				! Gauss abscissas [-1,+1]
	real*8 Jib(2,2,Nb,Ng), a33(Nb)		! boundary geometric entities
	real*8 Shpb(2,Nb,Ng), dNdrb(2,2,Nb,Ng)	! boundary shape functions

	integer e, Gn1, Gn2, Ln1, Ln2, i1, i2, i3, i4, Lf, n, g1b, i, k, ii
	real*8 Jb(2,2), Jacb, Jacib
	real*8 Shp(4), dNdr(4,2)
	real*8 r, s

!	write(idbg,'(a)') ' --- SHAPEB ---'	! ### TEMPORARY ###
! linear 2D shape functions
! Ni(r,s) = (1 +/- r)(1 +/- s) / 4 ; -1 < r, s < +1
	do n = 1, Nb
	  Gn1= BCe(n,1)		! BC global node 1 number
	  Gn2= BCe(n,2)		! BC global node 2 number
	  e  = BCe(n,3)		! BC element number
	  Lf = BCi(n)		! BC local face number

! calculate the face Jacobian, a33 (!!! for linear shape functions ONLY !!!)
	  i1 = ie(e,1)			! 1st node
	  i2 = ie(e,2)			! 2nd node
	  i3 = ie(e,3)			! 3rd node
	  i4 = ie(e,4)			! 4th node
	  if     (Lf .eq. 1) then				! face 1, s=-1
	    s = -1.
	    Ln1 = 1						! local node 1
	    Ln2 = 2						! local node 2
	    a33(n) = Sx * 0.5d0 * ( x(i2,1) - x(i1,1) )		! Sx*J11(s=-1)=Sx*(x2-x1)/2
	  else if(Lf .eq. 3) then				! face 3, s=+1
	    s =  1.
	    Ln1 = 3						! local node 1
	    Ln2 = 4						! local node 2
	    a33(n) = Sx * 0.5d0 * ( x(i3,1) - x(i4,1) )		! Sx*J11(s=+1)=Sx*(x3-x4)/2
	  else if(Lf .eq. 4) then				! face 4, r=-1
	    r = -1.
	    Ln1 = 4						! local node 1
	    Ln2 = 1						! local node 2
	    a33(n) = Sx * 0.5d0 * ( x(i4,2) - x(i1,2) )		! Sx*J22(r=-1)=Sx*(y4-y1)/2
	  else if(Lf .eq. 2) then				! face 2, r=+1
	    r =  1.
	    Ln1 = 2						! local node 1
	    Ln2 = 3						! local node 2
	    a33(n) = Sx * 0.5d0 * ( x(i3,2) - x(i2,2) )		! Sx*J22(r=+1)=Sx*(y3-y2)/2
	  endif

	  do g1b = 1, Ng

	    if(Lf.eq.1 .or. Lf.eq.3) then			! s=cons faces
	      r = xg(g1b)
	    else if(Lf.eq.2 .or. Lf.eq.4) then			! r=cons faces
	      s = xg(g1b)
	    endif

	    Shp(1) = 0.25d0 * (1.-r) * (1.-s)		! N1(r,s)
	    Shp(2) = 0.25d0 * (1.+r) * (1.-s)		! N2(r,s)
	    Shp(3) = 0.25d0 * (1.+r) * (1.+s)		! N3(r,s)
	    Shp(4) = 0.25d0 * (1.-r) * (1.+s)		! N4(r,s)

	    dNdr(1,1) =-0.25d0 * (1.-s)			! dN1(r,s)/dr
	    dNdr(2,1) = 0.25d0 * (1.-s)			! dN2(r,s)/dr
	    dNdr(3,1) = 0.25d0 * (1.+s)			! dN3(r,s)/dr
	    dNdr(4,1) =-0.25d0 * (1.+s)			! dN4(r,s)/dr

	    dNdr(1,2) =-0.25d0 * (1.-r)			! dN1(r,s)/ds
	    dNdr(2,2) =-0.25d0 * (1.+r)			! dN2(r,s)/ds
	    dNdr(3,2) = 0.25d0 * (1.+r)			! dN3(r,s)/ds
	    dNdr(4,2) = 0.25d0 * (1.-r)			! dN4(r,s)/ds

! Jb(i,j) the Jacobian matrix
	    Jb = 0.				! reset Jb, use matrix form 
	    do i = 1,2
	      do k = 1,2
	        do ii = 1,4
		  Jb(i,k) = Jb(i,k) + dNdr(ii,k) * x(ie(e,ii), i)
	        enddo	! ii
	      enddo	! k
	    enddo	! i

	    Jacb = Jb(1,1)*Jb(2,2) - Jb(1,2)*Jb(2,1)	! Jacobian determinant, |J|
	    Jacib = 1. / Jacb				! 1/|J|

! inv{Jb(i,j)}
	    Jib(1,1,n,g1b) = Jb(2,2)*Jacib
	    Jib(1,2,n,g1b) =-Jb(1,2)*Jacib
	    Jib(2,1,n,g1b) =-Jb(2,1)*Jacib
	    Jib(2,2,n,g1b) = Jb(1,1)*Jacib
! store
	    Shpb(1,n,g1b) = Shp(Ln1)			! N_I at node 1
	    Shpb(2,n,g1b) = Shp(Ln2)			! N_I at node 2
	    if(Lf.eq.1 .or. Lf.eq.3) then
	      dNdrb(1,1,n,g1b) = dNdr(Ln1,1)		! dN_I/dr at node 1
	      dNdrb(1,2,n,g1b) = 0.			! dN_I/ds at node 1
	      dNdrb(2,1,n,g1b) = dNdr(Ln2,1)		! dN_I/dr at node 2
	      dNdrb(2,2,n,g1b) = 0.			! dN_I/ds at node 2
	    else
	      dNdrb(1,1,n,g1b) = 0.			! dN_I/dr at node 1
	      dNdrb(1,2,n,g1b) = dNdr(Ln1,2)		! dN_I/ds at node 1
	      dNdrb(2,1,n,g1b) = 0.			! dN_I/dr at node 2
	      dNdrb(2,2,n,g1b) = dNdr(Ln2,2)		! dN_I/ds at node 2
	    endif

	  enddo	! g1b

	enddo	! n
	
	return
	end
